# -*- coding: utf-8 -*-
import argparse

parser = argparse.ArgumentParser(description='Training SNN')
parser.add_argument('--seed', default=None, type=int, help='random seed')
parser.add_argument('--arch', default="asgl_resnet18", type=str,
                    help="asgl_resnet18|asgl_resnet19")
parser.add_argument('--dataset', default="CIFAR100", type=str, help="CIFAR10|CIFAR100")
parser.add_argument('--data_path', default="/your data path", type=str)
parser.add_argument('--log_path', default="./log", type=str, help="log path")
parser.add_argument('--auto_aug', default=None, action='store_true')
parser.add_argument('--cutout', default=None, action='store_true')
parser.add_argument('--resume', default=None, type=str, help='pth file that holds the model parameters')
parser.add_argument('--train_batch_size', default=128, type=int)
parser.add_argument('--val_batch_size', default=128, type=int)
parser.add_argument('--device', default="cuda:0")
parser.add_argument('--lr', default=0.1, type=float)
parser.add_argument('--wd', default=5e-4, type=float)
parser.add_argument('--num_epoch', default=300, type=int)
parser.add_argument('--num_workers', default=8, type=int)
parser.add_argument('--optim', default='SGDM', type=str)
parser.add_argument('--decay', default=0.2, type=float)
parser.add_argument('--v_reset', default=None, type=float)
parser.add_argument('--thresh', default=1.0, type=float)
parser.add_argument('--train_thresh', action='store_true')
parser.add_argument('--T', default=6, type=int, help='num of time steps')
parser.add_argument('--scheduler', default='COSINE', type=str)
parser.add_argument('--detach_reset', default=True, action='store_true')
parser.add_argument('--alp', default=0.0, type=float)
parser.add_argument('--beta', default=0.0, type=float)
parser.add_argument('--scale', default=0.0, type=float)
args = parser.parse_args()
