This contains supplemental data for our submission for ICLR 2024 conference:
  Modelling brain connectomes networks: Solv is a worthy competitor to hyperbolic geometry!

Subdirectories:
- `hyperrogue` is the source code of RogueViz (cloned from https://github.com/zenorogue/hyperrogue/, commit fb5e4d25bb53fa5cde2084dc62ee72744a2f0e88 on Sep 22, 2023)
   we have implemented our Simulated Annealing embedder in file `hyperrogue/rogueviz/sag.cpp`
- `navigable-brain_maps_data` cloned from https://github.com/networkgeometry/navigable_brain_maps_data/ (v1.1)
- `honeycombs`, `*-geodesics.dat` and `DejaVuSans-Bold.ttf` are used by RogueViz
- `tes` will be created to contain tessellation data
- `embeddings` and `embeddings-long` contain the obtained embeddings
- `csv` contain the statistical data on embeddings and tessellations, as well as the R scripts used for statistical analysis

How to reproduce:
- compile RogueViz and our code using `compile.sh`
- produce tessellation data using `create-tes.sh` (note: ~800MB files created for each tessellation)
- embed connectomes using `embed.sh` (or `embed-long.sh`) (run multiple times to work on multiple embeddings at once; already computed files are skipped, so remove our files first)
- `sh make-csv.sh > csv/brains.csv`
- `sh make-csv-long.sh > csv/brains-long.csv`
- `sh geostat-csv.sh > csv/geostat.csv`

Note: each geometry 

To embed into BIG fragments;
- `sh create-big-tes.sh g711` (where `g711` is the tessellation name from create-tes.sh
  This creates file `/tmp/graph-BIG-g711`, which is about 20 GB.
- `sh embed-big.sh` and/or `sh embed-big-long.sh`

To visualize:
- `sh visualize.sh Cat1 g711 0`
- (Cat1 -- connectome to visualize, g711 -- tessellation name, 0 -- iteration number; this should work for small and short tessellations, not BIG or long ones)
