#!/bin/sh

SIZE=20000

EXEC=hyperrogue/hyper

mkdir -p tes/log tes/settings tes/graph tes/sizes

function solve {
  geomname=$1
  shift
  echo $* > tes/settings/$geomname
  echo $SIZE > tes/sizes/$geomname
  geostat=tes/log/log-$geomname
  if [ ! -f $geostat ]
  then

  echo doing $geomname `date`

  graph=tes/graph/$geomname
  echo $EXEC -c nul1 -nogui -fixx 0 -s nul -c nul1 -g -canvas 0 stamplen=9 -sag-creq $SIZE -sag_gdist 20 -threads 8 $* -sag-geo-stats -sag_gdist_save $graph -exit
  unbuffer $EXEC -c nul1 -nogui -fixx 0 -s nul -g -canvas 0 stamplen=9 -sag-creq $SIZE -sag_gdist 20 -threads 8 $* -sag-geo-stats -sag_gdist_save $graph -exit > $geostat
  fi
  }

function solveall {
  solve g711
  solve g435b2 -geo 435h -bch-subcubes 2
  return
  solve g435 -geo 435h
  solve nil -geo nil
  solve e3b -geo bitru
  solve h2r -product -threads 1 # not thread-safe
  solve h2ra -product -sag-angular 1 -threads 1 # also not thread-safe
  solve sol3 -geo sol -sag_gdist_dijkstra 3
  solve subsol3 -geo sol -gen-subcellpoints -sag_gdist_dijkstra 3
  solve twist -geo 4x5 -7 -rotspace -prodperiod 0 -sag_gdist_dijkstra 3
  solve subnil -geo nil -gen-subcellpoints
  solve g711d -sag-dtile
  solve g435d -geo 435h -sag-dtile
  solve tree -geo oox3
  solve treed -geo oox3 -sag-dtile

  SIZE=99999
  solve s3 -geo 8c -bch-subcubes 11 -sag_gdist 200
  solve t3 -geo beti -twist3 27 27 27 0 -sag_gdist_dijkstra 3
  solve h3m -geo 435h -to-fq EB201050 -bch-subcubes 2 -ray-dont -sag_gdist_dijkstra 3
  solve h2m -qpar2 0,2 -gp 3 0 -sag_gdist_dijkstra 5

  SIZE=40900
  solve g435ch -geo 435h

  SIZE=27000
  solve g711ch
  }

solveall
