#!/bin/sh

EXEC=hyperrogue/hyper
mkdir -p embeddings

function solve {
  geomname=$1
  shift
  log1=embeddings/log-$who-$geomname
  if [ ! -f $log1 ]
  then
  echo who=$who geomname=$geomname `date`
  graph=tes/graph/$geomname
  size=`cat tes/sizes/$geomname`
  unbuffer $EXEC -fixx 0 -nogui -s nul -g stamplen=9 -sag-creq $size -sag_gdist_load $graph -sagformat 1 -sag navigable_brain_maps_data/maps/$who/$who.edge -sag-v5 -exit > $log1
  fi
  }
           
for who in `ls navigable_brain_maps_data/maps`
do 
  for geo in `ls tes/settings`
  do
  solve $geo
  done
done
