from abc import abstractmethod, ABC

from .const_pde import ConstEquationSampler
from .burgers_pde import BurgersEquationSampler


def get_pde(pde_type):
    if pde_type == 'const':
        return ConstEquationSampler
    elif pde_type == 'burgers':
        return BurgersEquationSampler
    else:
        raise ValueError('Wrong type of PDE. Supported types: [const / burgers]')


class Sampler(ABC):
    def __init__(self, x_len, t_len, delta_x, delta_t):
        self.x_len = x_len
        self.t_len = t_len
        self.delta_x = delta_x
        self.delta_t = delta_t

        # self.x_seq = np.arange(0.0, self.x_len * self.delta_x, self.delta_x)
        # self.t_seq = np.arange(0.0, self.t_len * self.delta_t, self.delta_t)

    @staticmethod
    def get_boundary_conditions(low=0.0, high=0.0):
        bc_x_left = {'value': low}
        bc_x_right = {'value': high}
        bc_x = [bc_x_left, bc_x_right]
        return bc_x