# %%
from pathlib import Path

from core import ADAPTER_PATH, MODEL_PATH, BASE_PATH
from core.llm import LLM

def merge_adapter(
        adapter_path: Path,
        save_path: Path
    ):
    """
    Merge the adapters in the specified path into the model and save the model.
    """
    llm = LLM.from_adapter(adapter_path)
    llm.load_model()

    llm.model.save_pretrained(save_path)
    llm.tokenizer.save_pretrained(save_path)
    print(f"Model saved to {save_path}.")

# %%
MODEL_PATH = Path("merged_checkpoints")
project_name = "huggingface"
adapter_names = []

for adapter_name in adapter_names:
    #adapter_path = ADAPTER_PATH / project_name / adapter_name
    adapter_path = BASE_PATH / "checkpoints" / project_name / adapter_name
    save_path = MODEL_PATH / adapter_name

    print(adapter_path)
    print(save_path)

    merge_adapter(adapter_path, save_path)

