function [sol, cnt] = Newton(A, b, p, reg, tol)
    cnt = 0;
    x = InitialSoln(A, b);
    [n, d] = size(A);
    mm = objective(A,b,p,reg,x);
    best = x;
    while true
        cnt = cnt + 1;
        k = (abs(A*x-b)).^(p-2) ;
        s = p*(p-1)*k + 2*reg;
        R = spdiags(s, zeros(1,1), n, n);
        Calc = transpose(A)*R*A;
        g = p*k.*(A*x-b) + 2*reg*(A*x-b);
        B = transpose(A)* g; 
        delta = Calc \ B;
        alpha = LineSearchObj(A,b,x,p,delta,reg);  
        if transpose(B)*delta < tol
            break
        end
        x = x-alpha*delta;
        if objective(A,b,p,reg,x) < mm 
            mm = objective(A,b,p,reg,x);
            best = x;
        end
    end
    sol = best;
    
end

function [l] = objective(A,b,p,reg,x)

    l = norm(A*x-b, p)^p+reg*norm(A*x-b, 2)^2;
end
function [ f ] = InitialSoln(A, b)
    

    Calc = transpose(A)*A;
    t = transpose(A) * b;

    % f = Calc \ t;
    f = pinv(Calc) * t;
    
end

function obj = GradientScaledObj(scale,p,z,w,reg)
    v = z - scale*w;
    y = abs(v).^(p-2);
    y1 = v .* (p*y + 2*reg);
    obj = -1 * (w' * y1);
end

% This finds a scaling so that given the current solution x and the next
% step delta, we can scale delta so as to make maximum progress.
function alpha = LineSearchObj(A,b,x,p,delta,reg)
    L = -3;
    U = 3;
    w = A * delta;
    z = A * x - b;
    while GradientScaledObj(U,p,z,w,reg)<0
        L = U;
        U = 2*U;
    end
    while GradientScaledObj(L,p,z,w,reg)>0
        U = L;
        L = 2*L;
    end
    assert (GradientScaledObj(L,p,z,w,reg) < 0);
    assert (GradientScaledObj(U,p,z,w,reg) > 0);
    while abs(U-L)>1e-1
        if (GradientScaledObj((L+U)/2,p,z,w,reg)>0)
            U = (L+U)/2;
        else
            L = (L+U)/2;
        end
    end
    alpha = (L+U)/2;

end