function [w] = LewisWeights(A, T)
    [n, d] = size(A);
    u = d/n * ones(n,1);
    w = zeros(n,1);
    for t=1:T
        % disp(t);
        P = spdiags(u,zeros(1,1),n,n).^(1/2)*A;
        [U, S, V] = svd(transpose(P)*P);
        v = 1./diag(S);
        Z = P * V * spdiags(v,zeros(1,1),d,d).^(1/2);
        u = sum(Z.^2, 2);
        w = w + u;
    end
    w = 3/(2*T)*w;