
trial = 5;
dataset = "random";
% dataset = "protein";
% Ain = readmatrix("data/A_"+dataset+".csv");
% bin = readmatrix("data/b_"+dataset+".csv");

p = 8;
eps = 1e-10;
reg = 1;
for t=1:trial
    for s=1:10
        rng(t+s);
        d = 100;
        if s <= 10
            n = 500*s;
        else
            n = 100000;
        end
        A = rand(n,d);
        b =  rand(n,1);
        [n, d] = size(A);
        N = zeros(1,d);
        xx = rand(d,1);
        vv = N*xx;

        tic
        [final,call] = LewisIRLS2(eps,p,A,b,N,vv,reg);
        t1 = toc;


        x = final;
        % disp(x);
        out1 = norm(A*x-b, p)^p+reg*norm(A*x-b, 2)^2;
        cnt1 = call;
        vio1 = norm(N*x - vv, 2);
        P1 = [out1 cnt1 vio1 t1];

        name1 = "constrained_IRLS_" + string(p) + "_" + string(n) + "_" + string(d) + "_" + string(t);
        fileID = fopen('neurips_qsc/'+dataset+"_"+name1+'.txt','w');
        fprintf(fileID, '%.12f %.1f %.5f %.12f', out1, cnt1, t1, vio1);
        fclose(fileID);
        

        tic
        [x, cnt2] = Newton(A, b, p, reg, eps);
        t2 = toc;
        out2 = norm(A*x-b, p)^p+reg*norm(A*x-b, 2)^2;
        vio2 = norm(N*x - vv, 2);
        P2 = [out2 cnt2 t2 vio2];
        
        name2 = "_Newton_" + string(p) + "_" + string(n) + "_" + string(d) + "_" + string(t);
        fileID = fopen('neurips_qsc/'+dataset+"_"+name2+'.txt','w');
        fprintf(fileID, '%.12f %.1f %.5f %.12f', out2, cnt2, t2, vio2);
        fclose(fileID);

        if s <= 5
            tic
            cvx_begin
                variable x(d);
                minimize( pow_pos(norm((A*x-b),p), p) + reg*pow_pos(norm((A*x-b),2), 2) );
                subject to
                    N*x == vv;
            cvx_end
            t3 = toc;

            out3 = norm(A*x-b, p)^p+reg*norm(A*x-b, 2)^2;
            cnt3 = cvx_slvitr;
            vio3 = norm(N*x-vv);

            name3 = "constrained_cvx_" + string(p) + "_" + string(n) + "_" + string(d) + "_" + string(t);
            fileID = fopen('neurips_qsc/'+dataset+"_"+name3+'.txt','w');
            fprintf(fileID, '%.12f %.1f %.5f %.12f', out3, cnt3, t3, vio3);
            fclose(fileID);
        end
    end
end
