%%% void show_results(matrix,matrix,int,int,int)
% I - Input sequence
% L - Low-rank sequence
% nFrame - Number of frames
% vidHeight - Video height
% vidWidth - Video width
%
function show_results(I,L,nFrame,vidHeight,vidWidth)
  warning('off','all');
  clf;
  for i = 1:nFrame
    Input = reshape(I(:,i),vidHeight,vidWidth);
    %Input = uint8(Input);
    
    if(size(L) == size(I))
      LowRank = reshape(L(:,i),vidHeight,vidWidth);
      %LowRank1 = reshape(L(:,i),vidHeight,vidWidth);
      %LowRank = mat2gray(LowRank1);
      %LowRank = im2uint8(LowRank);
    else
      LowRank = uint8(zeros(size(Input)));
    end

    subplot(1,2,1), imshow(Input,[]), title('Input (I)');
    subplot(1,2,2), imshow(LowRank,[]), title('Low Rank (L)');
    %disp(i);
    pause(0.01);
  end
  warning('on','all');
end

