function[L, S] = AltPGD_SparsePlusLowrank_BackgroundModeling(Y, S0, L0, kmax)

% AltPGD_SparsePlusLowrank_BackgroundModeling    Sovle background modeling
% problem as robust PCA by AltPGD
% [L, S] = AltPGD_SparsePlusLowrank_BackgroundModeling(Y, S0, L0, kmax)
% Y - Matrix constructed by video frames
% S0 - Initial sparse matrix
% L0 - Initial low-rank matrix
% kmax - Maximum iteration
% L - Estimated low-rank matrix
% S - Estimated sparse matrix

[n, d] = size(Y);

k = 1;

%%%%%Step size
tk = 1;

%%%%%Constraint parameters selected by cross validation
R1 = 4.5e3;
R2 = 4.45e5;

epsilon = 1e-2;

while k <= kmax
    
    tempS = S0 - ((S0 + L0) - Y);
    
    vecS = ProjectOntoL1Ball(reshape(tempS, n * d, 1), R1);
    S = reshape(vecS, n, d);
    
    tempL = L0 - ((S0 + L0) - Y);
    
    [U, Sigma, V] = svd(tempL, 'econ');
    SigmaPGD = diag(ProjectOntoL1Ball(diag(Sigma), R2));
    L = U * SigmaPGD * V';
    
    if norm(S - S0, 'fro') < epsilon && norm(L - L0, 'fro') < epsilon
       break
    end
    
    if norm(Y - S - L, 'fro') / norm(Y, 'fro') < epsilon
        break
    end
    
    k = k + 1;
    
    S0 = S;
    L0 = L;
    

end

end