function[TPR, FAR, EE, Time] = AltPGD_SparsePlusLowrank_Summary(X, Y, S0, L0, kmax, Sstar, Lstar)

% AltPGD_SparsePlusLowrank_Summary    Calculate performance metrics for
% sparse plus low-rank network learning by AltPGD
% [TPR, FAR, EE, Time] = AltPGD_SparsePlusLowrank_Summary(X, Y, S0, L0, kmax, Sstar, Lstar)
% X - Data matrix
% Y - Measurement matrix
% S0 - Initial sparse matrix
% L0 - Initial low-rank matrix
% kmax - Maximum iteration
% Sstar - Real sparse matrix
% Lstar - Real low-rank matrix
% TPR - True positive rate
% FAR - False alarm rate
% EE - Relative estimation error
% Time - Calculation time

[n, d] = size(X);

%%%%%Initialization
TPR = 0;
FAR = 0;
EE = 0;
Time = 0;

k = 1;

%%%%%Step size
Cov = 1 / n * X' * X;
tk = 1 / max(eig(Cov)) / n / 1;

vecSstar = reshape(Sstar', d * d, 1);
R1 = 1*norm(vecSstar, 1);

R2 = norm(svd(Lstar), 1);

epsilon = 1e-2;

tic
while k <= kmax
    
    tempS = S0 - tk * X' * (X * (S0 + L0) - Y');
    
    vecS = ProjectOntoL1Ball(reshape(tempS, d * d, 1), R1);
    S = reshape(vecS, d, d);
    
    tempL = L0 - tk * X' * (X * (S0 + L0) - Y');
    
    [U, Sigma, V] = svd(tempL);
    SigmaPGD = diag(ProjectOntoL1Ball(diag(Sigma), R2));
    L = U * SigmaPGD * V';
    
    k = k + 1;

    if norm(S - S0, 'fro') < epsilon && norm(L - L0, 'fro') < epsilon
        break;
    end
    
    S0 = S;
    L0 = L;

end

Time = toc;

suppS = find(vecS);
suppSstar = find(vecSstar);
TPR = length(intersect(suppS, suppSstar)) / length(suppSstar);
zeroS = find(vecS == 0);
zeroSstar = find(vecSstar == 0);
FAR = length(intersect(zeroS, suppSstar)) / length(zeroSstar);
EE = norm(S + L - Sstar' - Lstar', 'fro') / norm(Sstar' + Lstar', 'fro');


end