function[squaredError] = PGD_Lowrank_ErrorScale(X, Y, L0, kmax, Lstar)

% PGD_Lowrank_ErrorScale    Calculate squared error of low-rank transition matrices estimation by PGD
% [squaredError] = PGD_Lowrank_ErrorScale(X, Y, L0, kmax, Lstar)
% X - Data matrix
% Y - Measurement matrix
% L0 - Initial point
% kmax - Maximum iteration
% Lstar - Real transition matrix
% squaredError - Squared errors of transition matrices estimation

[n, p] = size(X);

%%%%%Initialization
squaredError = 0;

k = 1;

%%%%%Step size
Cov = 1 / n * X' * X;
tk = 1 / max(eig(Cov)) / n / 1;

RL = norm(svd(Lstar), 1);

epsilon = 1e-2;

while k <= kmax
    
    
    tempL = L0 - tk * X' * (X * (L0) - Y');
    
    [U, Sigma, V] = svd(tempL);
    SigmaPGD = diag(ProjectOntoL1Ball(diag(Sigma), RL));
    L = U * SigmaPGD * V';
    
    k = k + 1;
    
    if norm(L - L0, 'fro') < epsilon
        break;
    end
    
    L0 = L;
    

end


squaredError = (norm(L - Lstar', 'fro'))^2;


end