function[A] = PGD_l1ball_Stock_Crossvalidation(X, Y, A0, kmax, D)


% PGD_l1ball_Stock_Crossvalidation    Calculate sparse transition matrix
% through stocks data
% [A] = PGD_l1ball_Stock_Crossvalidation(X, Y, A0, kmax, D)
% X - Data matrix
% Y - Measurement matrix
% A0 - Initial point
% kmax - Maximum iteration
% D - Constraint parameter
% A - Estimated transition matrix


[n, d] = size(X);

k = 0;

%%%%%Step size
S = 1 / n * X' * X;
tk = 1 / max(eig(S)) / n / 1;

epsilon = 1e-3;

while k <= kmax
    
    temp = A0 - tk * X' * (X * A0 - Y);
    
    z = ProjectOntoL1Ball(reshape(temp, d * d, 1), D);
    
    A = reshape(z, d, d);

    if norm(A - A0, 'fro') < epsilon 
        break
    end
    
    A0 = A;
    
    k = k + 1;

end
end