%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%proximal operator for l1 norm $\lambda \lonenorm(x) + 1 / t * ltwonorm(x
%%- z)^2$

function [x_new] = prox_operator_l1(x_old, lambda, step_size)
    
    n = length(x_old);
    
    x_new = sign(x_old) .* max(zeros(n, 1), abs(x_old) - lambda * step_size);

end