%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%proximal operator for nuclear norm $\lambda \nnorm(x) + 1 / t * \fnorm(x
%%- z)^2$

function [x_new] = prox_operator_nuclear(x_old, lambda, step_size)
    
    [m, n] = size(x_old);
    
    [U, S, V] = svd(x_old);
    
    S_new = sign(S) .* max(zeros(m, 1), abs(S) - lambda * step_size);
    
    x_new = U * S_new * V';

end