clc;
clear all;

% Solve background modeling problem as robust PCA by AltPGD

addpath(genpath('..\Software_Linear_Convergence_VAR'));

input_avi = 'highway.avi';

displog(['Loading ' input_avi]);
video = load_video_file(input_avi);

%%%%%Initialization
M_total = [];
L_total = [];
M = []; 

k = 1; 
%%%%%Partition video frames
k_max = 200;
nframes = 1600; % video.nrFramesTotal;

for i = 1 : nframes
  %disp(['#frame ' num2str(i)]);
  frame = video.frames(i).cdata;
  if(size(frame,3) == 3)
    frame = rgb2gray(frame);
  end
  I = reshape(frame,[],1);
  M(:,k) = I;
  if(k == k_max || i == nframes)
    disp(['#last frame ' num2str(i)]);
    M = im2double(M);
    tic;
    out = run_algorithm(M, []);

    toc
    M_total = [M_total M];
    L_total = [L_total out.L];
    displog('Displaying results...');
    show_results(M,out.L,size(M,2),video.height,video.width);
    M = []; 
    k = 0;
    %break;
  end
  k = k + 1;
end


disp('Finished');