function[squaredError] = AltPGD_SparsePlusLowrank_ErrorScale(X, Y, S0, L0, kmax, Sstar, Lstar)

% AltPGD_SparsePlusLowrank_ErrorScale    Calculate squared error of sparse plus low-rank transition matrices estimation by AltPGD
% [squaredError] = AltPGD_SparsePlusLowrank_ErrorScale(X, Y, S0, L0, kmax, Sstar, Lstar)
% X - Data matrix
% Y - Measurement matrix
% S0 - Initial sparse matrix
% L0 - Initial low-rank matrix
% kmax - Maximum iteration
% Sstar - Real sparse matrix
% Lstar - Real low-rank matrix
% squaredError - Squared errors of transition matrices estimation

[n, d] = size(X);

%%%%%Initialization
squaredError = 0;

k = 1;

%%%%%Step size
Cov = 1 / n * X' * X;
tk = 1 / max(eig(Cov)) / n / 1;


vecSstar = reshape(Sstar', d * d, 1);
R1 = 1*norm(vecSstar, 1);

R2 = norm(svd(Lstar), 1);

epsilon = 1e-2;

while k <= kmax
    
    tempS = S0 - tk * X' * (X * (S0 + L0) - Y');
    
    vecS = ProjectOntoL1Ball(reshape(tempS, d * d, 1), R1);
    S = reshape(vecS, d, d);
    
    tempL = L0 - tk * X' * (X * (S0 + L0) - Y');
    
    [U, Sigma, V] = svd(tempL);
    SigmaPGD = diag(ProjectOntoL1Ball(diag(Sigma), R2));
    L = U * SigmaPGD * V';
    
    k = k + 1;
    
    if norm(S - S0, 'fro') < epsilon && norm(L - L0, 'fro') < epsilon
        break;
    end
    
    S0 = S;
    L0 = L;
    

end


squaredError = (norm(S - Sstar' + L - Lstar', 'fro'))^2;

end