function [TPR, FAR, EE, Time] = FNSL_sparsepluslowrank_Summary(X, Y, S0, L0, kmax, Sstar, Lstar)

% FNSL_sparsepluslowrank_Summary    Calculate performance metrics for sparse plus low-rank network learning by FNSL
% [TPR, FAR, EE, Time] = FNSL_sparsepluslowrank_Summary(X, Y, S0, L0, kmax, Sstar, Lstar)
% X - Data matrix
% Y - Measurement matrix
% S0 - Initial sparse matrix
% L0 - Initial low-rank matrix
% kmax - Maximum iteration
% Sstar - Real sparse matrix
% Lstar - Real low-rank matrix
% TPR - True positive rate
% FAR - False alarm rate
% EE - Relative estimation error
% Time - Calculation time

%%%%%Initialization
TPR = 0;
FAR = 0;
EE = 0;
Time = 0;

[n, d] = size(X);


alpha0 = 1;
etaMin = max(eig(X.' * X)) / 10;
eta00 = etaMin;

Savg0 = S0;
Lavg0 = L0;
Q0 = 0;


lambdaS = 0.6*sqrt(log(d) * n);
lambdaL = 1.3*sqrt(d * n);


k = 1;

epsilon = 1e-2;

tic
while k <= kmax
    
    while 1
    if k == 1
        alpha = alpha0;
        eta = alpha * eta00;
    else
        alpha = (- alpha0 * eta0 + sqrt(alpha0^2 * eta0^2 + 4 * eta00 * alpha0 * eta0)) / 2 / eta00;
        eta = alpha * eta00;
    end
    
    Smd = (1 - alpha) * Savg0 + alpha * S0;
    Lmd = (1 - alpha) * Lavg0 + alpha * L0;
    
    tempS = S0 - 1 / eta * X' * (X * (Smd + Lmd) - Y');
    
    vecS = prox_operator_l1(reshape(tempS, d*d, 1), lambdaS, 1 / eta);
    
    S = reshape(vecS, d, d);
    
    tempL = L0 - 1 / eta * X' * (X * (Smd + Lmd) - Y');
    
    L = prox_operator_nuclear(tempL, lambdaL, 1 / eta);
    
    Gamma = norm(S - S0 + L - L0)^2  - alpha / eta * norm(X * (S - S0 + L - L0), 'fro')^2;
    
    Q = (1 - 1 / k)^2 * Q0 + Gamma;
    
    if Q < - 1 / k^2
        eta00 = 1.5 * eta00;
    else
        break
    end
    end
    
    Savg = (1 - alpha) * Savg0 + alpha * S;
    Lavg = (1 - alpha) * Lavg0 + alpha * L;

    k = k + 1;
    
    if norm(Savg - Savg0, 'fro') < epsilon && norm(Lavg - Lavg0, 'fro') < epsilon
        break
    end
    
  
    eta00 = max(etaMin, norm(X*(S - S0 + L - L0), 'fro')^2 / norm(S - S0 + L - L0, 'fro')^2);
    alpha0 = alpha;
    Savg0 = Savg;
    Lavg0 = Lavg;
    S0 = S;
    L0 = L;
    Q0 = Q;
    eta0 = eta;    
    
end
Time = toc;

suppS = find(reshape(Savg, d*d, 1));
suppSstar = find(reshape(Sstar', d*d, 1));
TPR = length(intersect(suppS, suppSstar)) / length(suppSstar);
zeroS = find(reshape(Savg, d*d, 1) == 0);
zeroSstar = find(reshape(Sstar', d*d, 1) == 0);
FAR = length(intersect(zeroS, suppSstar)) / length(zeroSstar);   
EE = norm(Savg + Lavg - Sstar' - Lstar', 'fro') / norm(Sstar' + Lstar', 'fro');

        
end
