function [Data xStart] = ARProduce(x0, A, E, T)

% ARProduce    Produce a stable AR sequence
% [Data xStart] = ARProduce(x0, A, E, T)
% x0 - Initial point
% A - Transition matrix
% E - Noise matrix
% T - Length of process
% Data - Produced sequence [x1, ..., xn]
% xStart - Starting point of stable sequence

d = length(x0);
Data = zeros(d, T);

xt = x0;

EExtended = eye(d) * randn(d, 4 * T); 

for i = 1 : 4 * T
    xtp = A * xt + EExtended(:, i);
    xt = xtp;
end

xStart = xt;

for i = 1 : T
    xtp = A * xt + E(:, i);
    
    Data(:, i) = xtp;
    xt = xtp;
    
end

end
