function[A] = PGD_Sparse_StockPriceEvaluation(X, Y, A0, kmax)

% PGD_Sparse_StockPriceEvaluation    Calculate sparse transition matrix
% through stocks data
% [A] = PGD_Sparse_StockPriceEvaluation(X, Y, A0, kmax)
% X - Data matrix
% Y - Measurement matrix
% A0 - Initial point
% kmax - Maximum iteration
% A - Estimated transition matrix

[n, d] = size(X);


k = 0;

%%%%%Step size
S = 1 / n * X' * X;
tk = 1 / max(eig(S)) / n / 1;

%%%%%Constraint parameter selected by cross validation
D = 180;

epsilon = 1e-2;

while k <= kmax
    
    temp = A0 - tk * X' * (X * A0 - Y);
    
    z = ProjectOntoL1Ball(reshape(temp, d * d, 1), D);
    
    A = reshape(z, d, d);
    

    if norm(A - A0, 'fro') < epsilon 
        break
    end
    
    A0 = A;
    
    k = k + 1;

end

end