function[TPR, FAR, EE, Time] = PGD_Sparse_Summary(X, Y, S0, kmax, Sstar)

% PGD_Sparse_Summary    Calculate performance metrics for sparse network learning by FNSL
% [TPR, FAR, EE, Time] = PGD_Sparse_Summary(X, Y, S0, kmax, Sstar)
% X - Data matrix
% Y - Measurement matrix
% S0 - Initial point
% kmax - Maximum iteration
% Sstar - Real transition matrix
% TPR - True positive rate
% FAR - False alarm rate
% EE - Relative estimation error
% Time - Calculation time

[n, d] = size(X);

%%%%%Initialization
TPR = 0;
FAR = 0;
EE = 0;
Time = 0;

k = 1;

%%%%%Step size
Cov = 1 / n * X' * X;
tk = 1 / max(eig(Cov)) / n / 1;

vecSstar = reshape(Sstar', d * d, 1);
R1 = norm(vecSstar, 1);

epsilon = 1e-2;

tic
while k <= kmax
    
    tempS = S0 - tk * X' * (X * (S0) - Y');
    
    vecS = ProjectOntoL1Ball(reshape(tempS, d * d, 1), R1);
    S = reshape(vecS, d, d);
      
    k = k + 1;

    if norm(S - S0, 'fro') < epsilon 
        break;
    end
    
    S0 = S;

end

Time = toc;

suppS = find(vecS);
suppSstar = find(vecSstar);
TPR = length(intersect(suppS, suppSstar)) / length(suppSstar);
zeroS = find(vecS == 0);
zeroSstar = find(vecSstar == 0);
FAR = length(intersect(zeroS, suppSstar)) / length(zeroSstar);
EE = norm(S - Sstar', 'fro') / norm(Sstar', 'fro');

end