#!/bin/bash

# VLLM模型部署脚本
# 基于run_model.py中的配置，部署模型到本地服务器
source .venv/bin/activate

# 模型路径（来自run_model.py中的模型路径）
# MODEL_PATH="/data/yutao/model/yutao_test_train/checkpoint-1768" # sft+rft
# MODEL_PATH="/data/yutao/model/qwen2.5-7b-0816/qwen2.5-7b-2225q-2069q-1369q-newbs-old-click-xep-lr5e-6/checkpoint-636" # sft
# MODEL_PATH="/data/yutao/model/yutao_test_train_0918/checkpoint-790" # sft+rft rule
# MODEL_PATH="/data/yutao/model/qwen2.5-7b-0816/qwen2.5-7b-2000q-2000q-1369q-nomemory-newbs-old-click-2ep-lr1e-6/checkpoint-636" # nomemory
MODEL_PATH="/data/yutao/model/iclr_agent_new/qwen2.5-3b-2000q-2000q-1369q-newbs-old-click-4ep-lr1e-6/checkpoint-2542" # rft format

# 服务器配置（基于run_model.py中的OpenAI客户端配置）
HOST="localhost"
PORT=5002

# VLLM参数配置
TENSOR_PARALLEL_SIZE=4  # 使用2张GPU卡
MAX_MODEL_LEN=32768      # 最大序列长度
GPU_MEMORY_UTILIZATION=0.9  # GPU内存使用率，8卡可以适当提高

# 设置GPU环境变量
export CUDA_VISIBLE_DEVICES=0,1,2,3
export NCCL_P2P_DISABLE=1  # 在某些情况下可能需要禁用P2P通信
export NCCL_IB_DISABLE=1   # 如果遇到InfiniBand问题可启用

echo "正在启动VLLM服务器..."
echo "模型路径: $MODEL_PATH"
echo "服务地址: http://$HOST:$PORT"
echo "使用GPU: $CUDA_VISIBLE_DEVICES"
echo "Tensor并行大小: $TENSOR_PARALLEL_SIZE"

# 启动VLLM OpenAI兼容服务器
python -m vllm.entrypoints.openai.api_server \
    --model "$MODEL_PATH" \
    --host "$HOST" \
    --port "$PORT" \
    --tensor-parallel-size "$TENSOR_PARALLEL_SIZE" \
    --max-model-len "$MAX_MODEL_LEN" \
    --gpu-memory-utilization "$GPU_MEMORY_UTILIZATION" \
    --served-model-name "qwen2.5-7b" \
    --trust-remote-code \
    --disable-log-requests \
    --api-key "sk-proj-1234567890"

echo "VLLM服务器已启动完成！"
