## Overview

Due to external clearance requirements, only small subsets of the datasets are provided here.
At the moment the repository only includes code for browsing and inspecting the datasets, not the full data or generation/inference code.
The full datasets, together with the data generation and inference code, will be released once the clearance process is complete.

## Preparation

```bash
pip install -r requirements.txt
```

## Data Access

We provide two datasets—MathLens and MathLens-General—in HuggingFace Datasets format:

```python

from datasets import load_from_disk

# MathLens - Mathematical Geometry Set
dset = load_from_disk("./data/mathlens")
dset['test']  # downstream problems with visual modifications
dset['perception_base_choice']  # perception probes

dset = load_from_disk("./data/mathlens_general")
dset['test']
dset['perception_base_choice']
```

We recommend using the provided viewers:

```bash
python viewer_mathlens.py
python viewer_mathlens_general.py
```
