# SCRIPT STARTS HERE 

# Global settings
GPSE_PATH= # path to results folder after pretraining
NUM_REPS=3
INIT_SEED=0 # we can always extend the number of runs by keeping NUM_REPS=1 and then increment INIT_SEED
WRAPPER=local  # local, wrapper_msuicer, wrapper_mila
CONFIG_DIR=configs/mol_bench
USE_WANDB=False
#################

# HOME_DIR=/vast/palmer/pi/krishnaswamy_smita/hcd22/SUMRY/GPSEv2
ROOT_DIR= # path to root of repo
# echo HOME_DIR=$HOME_DIR
echo ROOT_DIR=$ROOT_DIR

cd $ROOT_DIR

if [[ $WRAPPER != "local" ]]; then
    mkdir -p ${ROOT_DIR}/slurm_history
    job_script="sbatch -c 5 --mem=45GB -o ${ROOT_DIR}/slurm_history/slurm-%A.out run/${WRAPPER}.sb "
fi

launch () {
    dataset=$1
    model=$2
    pse=$3

    name="${dataset}-${model}+${pse}"
    run_script="main.py --cfg ${CONFIG_DIR}/${name}.yaml --repeat ${NUM_REPS} seed ${INIT_SEED} wandb.use ${USE_WANDB} gpse_path ${GPSE_PATH}"
    full_script="${job_script}${run_script}"

    echo $full_script  # print out the command
    eval $full_script  # execute the command
}

# ZINC
launch zinc GPS GPSE

launch zinc GIN GPSE