# Try to find the dc1394 v2 lib and include files
#
# DC1394_INCLUDE_DIR
# DC1394_LIBRARIES
# DC1394_FOUND

FIND_PATH( DC1394_INCLUDE_DIR dc1394/control.h
  /usr/include
  /usr/local/include
)

FIND_LIBRARY( DC1394_LIBRARY dc1394
  /usr/lib64
  /usr/lib
  /usr/local/lib
)

IF(DC1394_INCLUDE_DIR AND DC1394_LIBRARY)
  SET( DC1394_FOUND TRUE )
  SET( DC1394_LIBRARIES ${DC1394_LIBRARY} )
ENDIF(DC1394_INCLUDE_DIR AND DC1394_LIBRARY)

IF(DC1394_FOUND)
   IF(NOT DC1394_FIND_QUIETLY)
      MESSAGE(STATUS "Found DC1394: ${DC1394_LIBRARY}")
   ENDIF(NOT DC1394_FIND_QUIETLY)
ELSE(DC1394_FOUND)
   IF(DC1394_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "Could not find libdc1394")
   ENDIF(DC1394_FIND_REQUIRED)
ENDIF(DC1394_FOUND)

