#Every update requires an update of these hashes and the version within the control file of each of the 32 ports.
#So it is probably better to have a central location for these hashes and let the ports update via a script
set(QT_MAJOR_MINOR_VER 5.15)
set(QT_PATCH_VER 3)
set(QT_UPDATE_VERSION 0) # Switch to update qt and not build qt. Creates a file cmake/qt_new_hashes.cmake in qt5-base with the new hashes.

set(QT_PORT_LIST base 3d activeqt charts connectivity datavis3d declarative gamepad graphicaleffects imageformats location macextras mqtt multimedia networkauth
                 purchasing quickcontrols quickcontrols2 remoteobjects script scxml sensors serialport speech svg tools virtualkeyboard webchannel websockets
                 webview winextras xmlpatterns doc x11extras androidextras translations serialbus webengine webglplugin wayland)

set(QT_HASH_qt5-base                01723eff5116a1d7d136fa32d2aee2691b227a241dbc160953ee72a8c0f3bc7ab771c17434629cabef419983ef43bb38aa6956ddcc09c9a82e116a50073b0079)
set(QT_HASH_qt5-3d                  1fa644ef53923b194efd2296c1505e2193897057774411b1bc50651c2fc4e781e427de13cdc4c1c770294a39d06f8e7360353361c75222c0eb457b560943d97c)
set(QT_HASH_qt5-activeqt            5a5fc0a98c4928e6cd27105e47288fe62713c0097a0c4fc555b3607b24f22eb0b9e5546944c7c8e6279d2a241a2935f9b7c64a2e2b5c635f0f35061227fee37a)
set(QT_HASH_qt5-androidextras       45957b9afccf147dfe75c210e77e7b12cd3d1c34855052773a8ccce62020acd06e9e8f5b848f32f1fdbdb8fa614877909b9a1517530aad643b8954200ec030ca)
set(QT_HASH_qt5-charts              5f03db6d8c99f696aba0528812924c4d6d1a6b1331449c5e23fb094f9166ed1f35cd3bb98e3f17daf4a9b3e7b00b8cdc569ac0200343cd47b5de04468acf1d48)
set(QT_HASH_qt5-connectivity        23e515e36da9fb75c280cd8edaf29f3ce7e669ba294d6c1768ccd9c9967ede02dae161a6736a7dac4aa7d8087a309d67b06ba68532684c72ca9964e6ce229534)
set(QT_HASH_qt5-datavis3d           d38150d80ca700ab33f10b50faa412d930aabda157e5c671a9aeb00e7b257573f5cf77de363e8885bf507f00ce16aa14f5a7885dd308c47c2eaad08910c44ff3)
set(QT_HASH_qt5-declarative         c0f8dba5ba9e211071d64ec9de7395925d97424be899292a83fe961091c6695bfe68395fed4b34a746a69293765122a5ee53c119053f01b5fc511f0dbf577597)
set(QT_HASH_qt5-doc                 bb23d6d65a7c39ed9119e0bf30810a94ad937cc3f9ab0004d0c3fda712a6fbe009fdef74f5fe1212bc68ad0851ada37592c11f6ef754b81eff2d9c453b3a995b)
set(QT_HASH_qt5-gamepad             6a95ed24452d4df07ce0cb6ee482a333b74559935867e32467b6eb66b3c9e6f45a09d0d2bf41f549e85400523e1bea2dc5e571ef58016544aa1f1b056b2accaa)
set(QT_HASH_qt5-graphicaleffects    500f22c3845a0aeb5900dce2664b931c177b9b8357eac51594e84bcd55949292d9001467ea317cc8bc020560cb17b56fa16e1d6fdfc8e11a869aaef8d54b6b98)
set(QT_HASH_qt5-imageformats        f4ee52dc8c48bb3e558802be2f7209bd90c35b89af366836615342b2c6981c4389ddf8651b00970c49ee472e9c663434646228c24659d9e2e5591e4c8f1ff26e)
set(QT_HASH_qt5-location            755434db4cdea1c98159a2891c3efcda03fd03b144c37e7a71f57cb5d5dbc5ea1b35d1dcafa7301fc904ede910b4a9f7cfc834b7722cc06fcc360ad3be7b2886)
set(QT_HASH_qt5-macextras           26ff64206d6b491271a2db8a6932b30fc8df6ff121ef272edca5e2ec61d98668e326102d529f9335eab98bb3e5e3261cb50db2b2f78f751226bb9d4aa84e499b)
set(QT_HASH_qt5-mqtt                df91daf1accdf93d05bad33b9abb4a69f2b3fcd91f6dbcd71d6c74c21b0f0b2aeabc83f64aa5c149321b1a700cde3d81a4cbfc8fad7cdd8b0d8c0cc073299f82)
set(QT_HASH_qt5-multimedia          8206df23a84ce77d234a97cd4847f7185d7b5ca2c6bf1cd48dc19c833a302f92f85c53d8bccd4bcfbfb6cdc82c2246b2fb62400eefd5d4b152e95e378dded668)
set(QT_HASH_qt5-networkauth         0d155fe4b50a412153a4da8423714aabaf24bdafa0dbe789a33c18b4111b0641c93dd0d5f31774c8ff5ccc0737cfde7992d8181a69d12c93ccebc7c65c5a1654)
set(QT_HASH_qt5-purchasing          33ce166c6f4e626fef4cc17e902a5117225fa87799687e6c0956898bf80e04df4f3fa447b466e43c9fac58e879a7c9fd0e8c18006e8aa69f0e8762b258c81674)
set(QT_HASH_qt5-quickcontrols       756bffb68ad3bd7b6f6c91dbf544e19ff897f8b97ef25bd5da7f9acf8edb903376776ab90cc1b4cf3a0a73e7be37bfbf06e3bfc9afd698aab83e27945c3a5b9e)
set(QT_HASH_qt5-quickcontrols2      c7127ed4b74c4d4d91ab7d167fffde0f20acbf75065be5e85adda19cd033afe4862430689e58a43719cab523864d615aa8befa004ae13e5337596dac1be0fddb)
set(QT_HASH_qt5-remoteobjects       a20699353269dd1d61ea9a45191aa6c438d597783c7461ee41c1bbde0d6043f2be138dd0f46744c1a3081c4098e66e78543f0397eb18b72aab99808de7855bd9)
set(QT_HASH_qt5-script              ce35799a5625226fd62b394ecdc9d6826ef386a4b2d1a085a3def927ff3cf4808542a7e06be313baf12838fa0d2c1dbe6496a4e34818e3d035734305e60c24d9)
set(QT_HASH_qt5-scxml               59b4f2f5bf86a6528cbcffa64a1f3d300fde8509f94c95956558f8643d8f4d093609f4f6d4c095a58e5ea639619f7fd0da6046b2cb72c3cf505859de83aa05d1)
set(QT_HASH_qt5-sensors             c9e69e78cbb3624cb1130c172a46d4916dbe5fc93f0f844262483468c2f53503844158e72b25692625f588452350bc2f125f583ef7244c62b2ea788ac72e32e2)
set(QT_HASH_qt5-serialbus           af04a26d31d627592e5d91b163fd7e968a0ff42812b6f7a9f0e73ae5da32cea9e3d49c4abb93d7badd61f0d63a976572a5b42ceb140c761807b31496a9f1af87)
set(QT_HASH_qt5-serialport          1fb4dbb5d41c3280b07119d625030489566be29a1b8a7c555f9d484a7dd8c812a7e831147a8017d9026a77fdd57d48985a96f4e6c7887d90342005cf496b7b3a)
set(QT_HASH_qt5-speech              43790477887f533df9a1cfeb60194e171cbdbb79bce0f7d90228750219a67baa4b94a7f9d3833958bf7f9553f3f6302f980f269ce52c3756c116a61eae632a2a)
set(QT_HASH_qt5-svg                 288ce98bb6dd746564c7ffbd0d8221d0816c62b7e33424cd21d945b40308292ec9a0b1e2b9cca6ce91d606c06813f05068cad590d827810383175bebfa8ab527)
set(QT_HASH_qt5-tools               3c4ffee1d67126e3dd10c1dabae3660b94b97541480814b77bc88c0eaf86d8d43324d582465521fbdbd49dbb4155561f93e91c998dc1ad6553da02a3fcb0da47)
set(QT_HASH_qt5-translations        d2939a93a328aa1a8011a0e61970d9ce6a99b918aa35dac9fe10d8b65662ea5086207708157751573431aa24973a1a07e05c25fb90a254861a40d85a845bb1dc)
set(QT_HASH_qt5-virtualkeyboard     f6033438d9a847d3592bcdbc9c525a2bac730621b2279b36157f8eb11c6f49fa27b5155835c3cc1fa412a0509ca387c5a7063d20b6ae0ff7aedaba786d3c75f2)
set(QT_HASH_qt5-webchannel          77ec10187601c826d15dad9a5112553bc1f954d11f54a40d38a2e1a1cf7412fe2c74e0b100c91befd8be06274dc537dbed4c6f858856a3b38974a363ff380415)
set(QT_HASH_qt5-webengine           d4d10f2f95437042dfc67cc9826e8e27d390f986a1202f1bd5a765ea1b985e93158bde3068410f0a84b268de50c3e6fc9f67c4419224caa6b87b940d70d0869c)
set(QT_HASH_qt5-webglplugin         01860ca3ce27630ca1a92eb6deb933959a3679fb579d4cb8a06884f51a672c355f6929355aa6d45f4c5d8ac026b4cecdc7a26d5b2e897ca75bb7a9331e2d3e0d)
set(QT_HASH_qt5-websockets          a4d1442028e842f5e97bb5d9142d2be768193a0807e51a72adc36bf9bf554fd3ae86373d3de841dc6e0c8bd8312d7bc23b2e46fdf90fce59ab5e35e4462ce4ea)
set(QT_HASH_qt5-webview             3a2a7c06df79a6ac4bfd3a45c2ad9e06dc1c2c71ca6a14f9006e031b0679549a9f1d09a9c82439c700e1c0c0785cf7baa402ea2d230a4ebd122dc4e5d2b07030)
set(QT_HASH_qt5-x11extras           eaf5e639c68cc4e1a35f82a877f461f8023b92dede3819808fdb7334364f4428400a94e7d8cff30985410bf7754258c6376504fd068ba3d792683fd23f586133)
set(QT_HASH_qt5-xmlpatterns         4a5f7d68db6f950caedbb94291ab6aad77e7c52cc8adea2e41ddf600106c8d75b4eef83bc716bb1aa3696042c48c34979d8d216a16ccec3a539118b46691c5a4)
set(QT_HASH_qt5-wayland             0a9768282170709050490fb1b9daef59c21c8b5c4785f56a452d7954ffb6f016ec836022693941c99c5c10b2c3c55c75ba37fdad09dd1e0cde627f8b87b90c89)
set(QT_HASH_qt5-winextras           d0707f865552645e82a493265b142171f14c126bd99325471b5d94593c95763d606be89fcc72f74f3192446e024c9be904c7d95816b2dd8e8cc7cf9f34a02f77)


if(QT_UPDATE_VERSION)
    message(STATUS "Running Qt in automatic version port update mode!")
    set(_VCPKG_INTERNAL_NO_HASH_CHECK 1)
    if("${PORT}" MATCHES "qt5-base")
        foreach(_current_qt_port ${QT_PORT_LIST})
            set(_current_control "${VCPKG_ROOT_DIR}/ports/qt5-${_current_qt_port}/vcpkg.json")
            file(READ ${_current_control} _control_contents)
            #message(STATUS "Before: \n${_control_contents}")
            string(REGEX REPLACE "\"version.*\": \"[0-9]+\.[0-9]+\.[0-9]+\",\n" "\"version\": \"${QT_MAJOR_MINOR_VER}.${QT_PATCH_VER}\",\n" _control_contents "${_control_contents}")
            string(REGEX REPLACE "\n  \"port-version\": [0-9]+," "" _control_contents "${_control_contents}")
            #message(STATUS "After: \n${_control_contents}")
            file(WRITE ${_current_control} "${_control_contents}")
            configure_file("${_current_control}" "${_current_control}" @ONLY NEWLINE_STYLE LF)
        endforeach()
    endif()
endif()
