import torch
import torch.nn as nn

class TwoLayerNet(nn.Module):
    def __init__(self, input_size, hidden_size, output_size):
        super(TwoLayerNet, self).__init__()
        self.fc1 = nn.Linear(input_size, hidden_size)
        # self.fc1_2 = nn.Linear(hidden_size, hidden_size)
        self.relu = nn.Tanh()
        # self.fc2_0 = nn.Linear(hidden_size, hidden_size)
        self.fc2 = nn.Linear(hidden_size, output_size)
        # self.softmax = nn.LogSoftmax(dim=1)

    def forward(self, x):
        # x = x.view(-1, 784)  
        x = self.fc1(x)
        # x = self.fc1_2(x)
        # x = self.relu(x)
        # x = self.fc2_0(x)
        x = self.relu(x)
        x = self.fc2(x)
        # x = self.softmax(x)
        return x

class CIFAR10CNN(nn.Module):
    def __init__(self):
        super(CIFAR10CNN, self).__init__()

        self.conv1 = nn.Sequential(
            nn.Conv2d(3, 16, kernel_size=3, stride=1, padding=1),
            nn.ReLU(),
            nn.MaxPool2d(kernel_size=2, stride=2)
        )
        

        self.conv2 = nn.Sequential(
            nn.Conv2d(16, 16, kernel_size=3, stride=1, padding=1),
            nn.ReLU(),
            nn.MaxPool2d(kernel_size=2, stride=2)
        )
        


        self.fc = nn.Sequential(
            nn.Linear(16 * 8 * 8, 512),
            nn.ReLU(),
            nn.Linear(512, 10)
        )

    def forward(self, x):
        # x shape: [batch_size, 3, 32, 32]
        x = self.conv1(x)  # -> [batch_size, 32, 16, 16]
        x = self.conv2(x)  # -> [batch_size, 64, 8, 8]
        # x = self.conv3(x)  # -> [batch_size, 128, 4, 4]
        x = x.view(x.size(0), -1)  #  -> [batch_size, 128*4*4]
        x = self.fc(x)     # -> [batch_size, 10]
        return x