import torch
import numpy as np

def data_generator(num_samples=200, input_dim=50):
    torch.manual_seed(42)
    np.random.seed(42)

    # 
    n_samples = num_samples  # 
    input_dim = input_dim   # 
    X = torch.randn(n_samples, input_dim)  # 

    # 
    true_w = torch.randn(input_dim, 1)  # 
    true_v = torch.randn(input_dim, 1)  # 

    # 
    true_u = torch.randn(input_dim, 1)  
    y = X @ true_w + (X**2) @ true_v + 0.1 * torch.randn(n_samples, 1)

    return X, y


