#ifndef run_algorithms
#define run_algorithms
#include <string>
#include "state.h"
#include "domains.h"
#include "bamdp_rollout_policy.h"

void runPGTabular(
    std::string folder,
    domain dom,
    std::vector<float> alphas,
    int evalRepeats,
    std::vector<int> evalTrials,
    int batchSize,
    float lr
);

void runMCTSOffline(
    std::string folder,
    domain dom,
    std::vector<float> alphas,
    int evalRepeats,
    std::vector<int> evalTrials,
    int batchSize,
    float bias,
    float widening,
    std::string strat,
    std::string optim
);

void runMCTS(
    std::string folder,
    domain dom,
    std::vector<float> alphas,
    int evalRepeats,
    std::vector<std::tuple<int, int, int>> trialsList,
    float bias,
    float widening,
    std::string strat,
    std::string optim,
    std::string rolloutPolName = "none"
);

void runPGApprox(
    std::string folder,
    domain dom,
    std::vector<float> alphas,
    int evalRepeats,
    std::vector<int> evalTrials,
    int batchSize,
    float lr,
    bool initCvarPolicy
);

void runBamdpCvarVI(
    std::string folder,
    domain dom,
    std::vector<float> alphas,
    int evalRepeats,
    int numInterpPts
);

void runExpectedMDPCvarVI(
    std::string folder,
    domain dom,
    std::vector<float> alphas,
    int evalRepeats,
    int numInterpPts
);

#endif
