class KIALO_DATA_PATH:
    best_match = "repos/pluralism/kialo/kialo_best_match_Qwen3-Embedding-8B.json"

class PROMPT:
    opinion_expansion_with_best_match = "Your task is to expand the opinion given topics and posts or comments from reddit that supports this opinion. It doesn't need to be too long, just 3 to 4 sentences expansion. Ignore the post / comment if it's irrelevant, and try to mimic the wording style of the post / comment. Rewrite and expand the opinion in a natural, Reddit-style way. The topic is: {topic}. The opinion is: {opinion}. The post or comment is: {post_or_comment}. Please directly output the expanded opinion, don't include any other text."
    
    opinion_counting = "Read the paragraph about \"{topic}\" and identify how many distinct opinions it contains. An opinion is a unique core stance; different wording with the same stance counts as one opinion. ONLY reply with an integer."
    opinion_matching = "Read the following expanded paragraph about \"{topic}\" and decide which one of the listed original opinions it best matches. Reply ONLY with the index of the correct option (0-based)."
    polarity_check = "Read the following concatenated opinions about \"{topic}\" and determine whether the majority stance is pro or con. Reply ONLY with 'pro' or 'con'."

    llm_as_judge_opinion_counting = "You are an evaluator for the Opinion Counting task. The model was asked to output how many distinct opinions are in the paragraph. Your job is to extract the integer from the model output. If no valid integer is found, return -100. Model output: {model_output}. Please return only the integer (e.g., 3) or -100."
    llm_as_judge_opinion_matching = "You are an evaluator for the Opinion Matching task. The model was asked to choose which original opinion (numbered options) corresponds to an expanded opinion. Your job is to extract the integer index of the chosen opinion from the model output. If no valid integer is found, return -100. Model output: {model_output}. Please return only the integer (e.g., 2) or -100."
    llm_as_judge_polarity_check = "You are an evaluator for the Polarity Check task. The model was asked to decide whether a concatenated paragraph of opinions overall leans PRO or CON. Your job is to extract the stance as 'pro', 'con'. If no valid stance is found, return -100. Model output: {model_output}. Please return only one of 'pro', 'con', or -100."


class TASK_NAME:
    OPINION_COUNTING = "opinion_counting"
    POLARITY_CHECK = "polarity_check"
    OPINION_MATCHING = "opinion_matching"

class MODEL_PATHS:
    LLAMA_3_1_8B_INSTRUCT = ""
    FALCON_3_7B_INSTRUCT = ""
    QWEN_3_8B = ""
    QWEN_3_32B = ""
    QWEN_2_5_7B_INSTRUCT = ""
    DEEPSEEK_R1_DISTILL_LLAMA_8B = ""
    DEEPSEEK_R1_DISTILL_QWEN_7B = ""
    DEEPSEEK_R1_DISTILL_QWEN_32B = ""
    QWEN_2_5_32B = ""
    QWEN_QWQ_32B = ""



