from web.evaluate import evaluate_on_all
from web.embeddings import load_embedding

import pandas as pd

def eval_embedding_single(file, count=None, dim=None, normalize=True):
    if count is None or dim is None:
        with open(file) as f:
            lines = 0
            if dim is None:
                l = f.readline()
                lines += 1
                dim = l.strip().count(' ')
            if count is None:
                for line in f:
                    lines += 1
                count = lines
                    
    return evaluate_on_all(load_embedding(file, format='glove', normalize=normalize, load_kwargs={'vocab_size': count, 'dim': dim}))

def eval_embedding(files, counts=None, dims=None, normalize=True):
    if counts is None:
        counts = [None] * len(files)
    if dims is None:
        dims = [None] * len(files)
        
    if len(files) != len(counts) or len(counts) != len(dims):
        raise Exception('Must have same number of counts and dims specified as files')
        
    return pd.concat([eval_embedding_single(f, c, d, normalize) for f,c,d in zip(files,counts,dims)])