# Discouraging posterior collapse in hierarchical Variational Autoencoders using context

This repository contains the code for the experiments from the paper.

---
## Abstract
<table>
<tr>
<td style="width:100%">
<i>
Hierarchical Variational Autoencoders (VAEs) are among the most popular likelihood-based generative models. 
There is a consensus that the top-down hierarchical VAEs allow effective learning of deep latent structures and avoid problems like posterior collapse. 
Here, we show that this is not necessarily the case, and the problem of collapsing posteriors remains. 
To discourage this issue, we propose a deep hierarchical VAE with a context on top. 
Specifically, we use a Discrete Cosine Transform to obtain the last latent variable.
In a series of experiments, we observe that the proposed modification allows us to achieve better utilization of the latent space and does not harm the model's generative abilities. 
</i>
</table>

## Experiments 
### Environment Setup
We list the required packages in `conda_requirements.yaml`:
```bash
conda env create -f conda_requirements.yaml
```

### Weights and Biases Setup
We use [w&b](https://wandb.ai) to track experiments, save and load trained models, thus it is required to run the code. 
Variables `entity`, `project` and `api_key` in the `configs/wandb/defaults.yaml` file should be specified before running the experiments.  

### Run experiments
Configuration for all the experiments are provided in `configs/experiments` folder. 

For example, to run the experiment with the MNIST dataset and the DCT-based hierarchical VAE, run the following command:
```bash
python -u run_experiment.py experiment=mnist_dct_ladder
```

We use 4-GPUs to train model on the CIFAR-10 dataset (make sure that `train.ddp: True`):
```bash
mpiexec -n 4 python -u run_experiment.py experiment=cifar_dct_ladder
```
