import os

from components.datasets.GPQA import GPQA
from components.instructors.InstructorOnInsightsFromPrior import InstructorOnInsightsFromPrior
from components.instructors.embedder.STEmbedder import STEmbedder
from components.instructors.retriever.denseRetriever import DenseRetriever
from components.models.GPT4o import GPT4o
from components.solvers.InstructedSolver import InstructedSolver
from components.models.GPT4oMini import GPT4oMini
from components.models.GPT5 import GPT5

NO_CACHE = True
NUM_RUNS = 1

DATASET = GPQA
size = 93

KNOWLEDGE_BASE = False
EXCLUDE_SELF= True

Components = {
    "INSTRUCTOR": InstructorOnInsightsFromPrior,
    "SOLVER": InstructedSolver
}

FALLBACK_THRESOLD = 0 ## If the similirity is greater than this value, the model will exploit the
# past knowledge by taking the instruction from the instructor. Otherwise, it will fall back to the baseline solver.


## FOR INSTRUCTOR
EMBEDDING_MODEL_PATH = "gbyuvd/ChemEmbed-v01"


EMBEDDING_PATH = (os.path.abspath(os.path.join(os.path.dirname(__file__), ".")) +
                  "/components/instructors/embedder/embeddings")
EMBEDDING_MODEL = STEmbedder(EMBEDDING_MODEL_PATH)
RETREIVER = DenseRetriever
RETREIVER_MODE = "question"

## FOR INSTRUCTOR
INSTRUCTOR = Components["INSTRUCTOR"]
INSTRUCTOR_MODEL = GPT4oMini
INSTRUCTOR_THRESHOLD_MIN = 0
INSTRUCTOR_THRESHOLD_MAX = 0.95
UTILIZED_KNOWLEDGE_INDEX_START = 0
UTILIZED_KNOWLEDGE_INDEX_END = 5

## FOR SOLVER
SOLVER= Components["SOLVER"]
SOLVER_MODEL = GPT4oMini


### Templates
BASELINE_PROMPT_TEMPLATE = """Consider the following question: 
{problem}

### Task:
Select the most appropriate answer.
Please think step by step."""

INSTRUCTOR_PROMPT_TEMPLATE = """
### Task:
1. Your task is to come up with meaningful insights from the following questions and their answers, in a bullet-point 
format.
{previous_problems_answers}
2. Refine your insights based on the following new question:
{target_problem}
"""

SOLVER_PROMPT_TEMPLATE = """Consider the following question: 
{problem}
### Task:
Select the most appropriate answer.
### Below are some insights that might be useful for you to solve the question:
{instruction}"""