from typing import List

import numpy as np

from src.entity.problems.Problem import Problem


class KnowledgeBase:
    name: str
    knowledges: List[Problem]
    # init
    def __init__(self, dataset_names: [str], knowledges: List[Problem]):
        self.name = '_'.join(dataset_names)
        self.knowledges = knowledges
        self.embeddings = []

    def add_embeddings(self):
        for knowledge in self.knowledges:
            self.embeddings.append(knowledge.embedding)

        # to a numpy array
        self.embeddings = np.array(self.embeddings)

    # check the problem's index in the knowledege base.
    def get_problem_index(self, problem):
        for _ in self.knowledges:
            if str(_) == str(problem):
                return self.knowledges.index(_)
        return -1