# Model is a simple class that handles the API requests to different end services.
import json

# import Model class
from openai import OpenAI
from src.entity.models.Model import Model
from credentials import OPENAI_CREDENTIAL

class GPT4o(Model):
    api_key: str
    def __init__(self, ctx_len: int=512):
        # load from environment variable.
        self.api_key = OPENAI_CREDENTIAL
        # self.ctx_len = ctx_len

    def interact(self, messages: str, **kwargs):
        # require a json_format, temperature, e.t.c

        json_format = kwargs.get("json_format")
        temperature = kwargs.get("temperature")

        messages = [
            {"role": "user", "content": messages}
        ] if isinstance(messages, str) else messages

        if json_format is None:
            raise ValueError("json_format is required")
        if temperature is None:
            raise ValueError("temperature is required")

        # call the API and return the response.
        client = OpenAI(api_key=self.api_key)
        prompt_input = {
            "model": "gpt-4o-2024-08-06",
            "messages": messages,
            "response_format": json_format,
            "temperature": 0,
            "n": 1
        }
        

        response = client.beta.chat.completions.parse(
            **prompt_input
        )
        # return a json of the response.
        response = json.loads(response.choices[0].message.content)
        return response