# Model is a simple class that handles the API requests to different end services.
import json
import os
from dotenv import load_dotenv

# import Model class
from openai import OpenAI
from src.entity.models.Model import Model

load_dotenv()

class GPT_Parse(Model):
    api_key: str
    def __init__(self, ctx_len: int=512):
        # load from environment variable.
        self.api_key = os.getenv("OPENAI_API_KEY")
        # self.ctx_len = ctx_len

    def interact(self, model, messages: str, **kwargs):
        # require a json_format, temperature, e.t.c

        text_format = kwargs.get("text_format")
        temperature = kwargs.get("temperature")

        messages = [
            {"role": "user", "content": messages}
        ] if isinstance(messages, str) else messages

        if text_format is None:
            raise ValueError("text_format is required")
        if temperature is None:
            raise ValueError("temperature is required")

        # call the API and return the response.
        client = OpenAI(api_key=self.api_key)
        prompt_input = {
            "model": model,
            "input": messages,
            "text_format": text_format,
            "temperature": 0
        }
        

        response = client.responses.parse(
            **prompt_input
        )
        # return a json of the response.
        response = response.output_parsed.model_dump()
        return response