from pylatexenc.latex2text import LatexNodes2Text


class Problem:
    """
    The Problem Object for this framework.
    """
    question: str
    context: str
    label: int
    candidates: list[str]
    explanation: str

    '''
    question: str. The question boday.
    context: str. The context of the question.
    label: int. The index of the correct answer in the candidates list. (optional only if the problem is close-ended)
    candidates: list[str]. The list of candidate solutions. (optional only if the problem is close-ended)
    '''
    def __init__(self, id, question, context = None, label = None, candidates = None, explanation = None, problem_index =
    None, reference_to = None, reference_type = None):
        self.id = id
        self.context = context
        self.question = LatexNodes2Text().latex_to_text(question)
        self.label = label # this is the index of the correct answer in the candidates list
        for i in range(len(candidates)):
            candidates[i] = LatexNodes2Text().latex_to_text(candidates[i])
        self.candidates = candidates
        self.explanation = explanation
        self.problem_index = problem_index
        self.mental_representation = None
        self.reference_to = reference_to
        self.reference_type = reference_type

    def add_embedding(self, embedding):
        self.embedding = embedding


    def __str__(self):
        # result = self.id + "\n"
        result = ""
        if self.context:
            result += f"Context: {self.context}\n"

        result += f"Question: {self.question}\n"

        if self.candidates:
            candidates = "\n" + "\n".join(
            f"{i+1}. {string}" for i, string in enumerate(self.candidates)
        )
            result += f"Candidates: {candidates}"

        return result

    def get_ground_truth(self):
        if self.candidates is None:
            raise NotImplementedError("This is an open-ended problem. There is no ground truth.")
        else:
            return self.candidates[self.label]

    def get_output_format(self):
        if self.candidates is None:
            return {
                "type": "string",
                "description": "The final answer"
            }
        else:
            return {
                "type": "string",
                "description": "The chosen candidate solution",
                "enum": [f"{string}" for string in self.candidates]
            }

    def evaluate_open_ended(self, response):
        raise NotImplementedError

    def evaluate_closed_ended(self, response) -> bool:
        answer = self.candidates[self.label]
        return response == answer

    def evalute(self, response):
        if self.label is None:
            return self.evaluate_open_ended(response)
        else:
            return self.evaluate_closed_ended(response)