from src.entity.KnowledgeBase import KnowledgeBase
from src.entity.datasets.GPQA import GPQA
from src.entity.datasets.GPQABiology import GPQABiology
from src.entity.datasets.GPQAPhysics import GPQAPhysics
from src.entity.datasets.Synthetic import Synthetic
from src.entity.datasets.SyntheticBiology import SyntheticBiology
from src.entity.datasets.SyntheticPhysics import SyntheticPhysics


def LoadingKnowledgeUseCase(dataset_names: [str]):
    """
    Load the knowledge bases for the given dataset names.

    dataset_names: list[str], names of the datasets to load.
    """

    knowledge_bases = []
    for dataset_name in dataset_names:
        if dataset_name == 'GPQA':
            dataset = GPQA(size=100000000)
            knowledge_bases.extend(dataset.problems)
        elif dataset_name == 'Synthetic':
            dataset = Synthetic(size=100000000)
            knowledge_bases.extend(dataset.problems)
        elif dataset_name == 'SyntheticPhysics':
            dataset = SyntheticPhysics(size=100000000)
            knowledge_bases.extend(dataset.problems)
        elif dataset_name == "GPQAPhysics":
            dataset = GPQAPhysics(size=100000000)
            knowledge_bases.extend(dataset.problems)
        elif dataset_name == "SyntheticBiology":
            dataset = SyntheticBiology(size=100000000)
            knowledge_bases.extend(dataset.problems)
        elif dataset_name == "GPQABiology":
            dataset = GPQABiology(size=100000000)
            knowledge_bases.extend(dataset.problems)
        elif dataset_name == "HLEChemistry":
            from src.entity.datasets.HLEChemistry import HLEChemistry
            dataset = HLEChemistry(size=100000000)
            knowledge_bases.extend(dataset.problems)
        elif dataset_name == "HLEChemistrySynthetic":
            from src.entity.datasets.HLEChemistrySynthetic import HLEChemistrySynthetic
            dataset = HLEChemistrySynthetic(size=100000000)
            knowledge_bases.extend(dataset.problems)
        elif dataset_name == "HLEMath":
            from src.entity.datasets.HLEMath import HLEMath
            dataset = HLEMath(size=100000000)
            knowledge_bases.extend(dataset.problems)

        elif dataset_name == "HLEMathSynthetic":
            from src.entity.datasets.HLEMathSynthetic import HLEMathSynthetic
            dataset = HLEMathSynthetic(size=100000000)
            knowledge_bases.extend(dataset.problems)
        else:
            raise ValueError(f"Dataset {dataset_name} is not supported.")
    return KnowledgeBase(dataset_names= dataset_names, knowledges= knowledge_bases)