import json
from src.entity.problems.Problem import Problem
from pydantic import BaseModel, Field
from enum import Enum
from typing import Type
from config import config
prompt = config["SCHEMA_PROMPT"]
Response = config["SCHEMA_RESPONSE_CLASS"]
SCHEMA_SOLVER_PROMPT = config["SCHEMA_SOLVER_PROMPT"]

def create_dynamic_enum(name: str, options: list[str]) -> Type[Enum]:
    return Enum(name, {option: option for option in options})

def ExampleSchemaSolverUseCase(problem: Problem, schema: str, solver_model, knowledges, knowledges_string):
    global prompt
    AnswerEnum = create_dynamic_enum("AnswerEnum", [f"{string}" for string in problem.candidates])

    class DynamicResponse(BaseModel):
        reasoning: str
        final_answer: AnswerEnum

    refinement_prompt = f"""Now that you've seen a similar question along with its schema and solution, reflect on 
    how you could refine or improve your previously generated schema for the **current** question. Focus on alignment 
    in categories, scope specificity, and consistency of abstraction.
{knowledges_string}"""

    messages = [
        {"role": "system", "content": SCHEMA_SOLVER_PROMPT},
        {"role": "user", "content": str(problem)},
        {"role": "assistant", "content": problem.mental_representation},
        {"role": "user", "content": refinement_prompt},
        {"role": "assistant", "content": schema},
        {"role": "user", "content": "Now that you've refined your schema for the current question, select the most appropriate answer. "}]

    # prompt = f"""Select the most appropriate answer."""
    #     answer_prompt = f"""Example:
    # {str(knowledge)}
    # Answer: {knowledge.get_ground_truth()}
    # {str(problem)}"""

    # answer_prompt = f"""{str(problem)}
    # {schema}"""
    # knowledge = knowledges[0]
    # messages = [{"role": "system", "content": prompt}, {"role": "user", "content": str(knowledge)},
    #     {"role": "assistant", "content": knowledge.get_ground_truth()}, {"role": "user", "content": answer_prompt}]

    prompt = messages

    response = solver_model.interact(messages, json_format=DynamicResponse, temperature=0)
    return response, response["final_answer"]
