import json

from src.entity.problems.Problem import Problem

from pydantic import BaseModel, Field
from enum import Enum
from typing import Type

# Function to dynamically create an Enum
def create_dynamic_enum(name: str, options: list[str]) -> Type[Enum]:
    return Enum(name, {option: option for option in options})

# Example Response model
class Response(BaseModel):
    reasoning: str
    final_answer: Enum


def ExampleSolverUseCase(problem: Problem, schema: str, solver_model, knowledges, knowledges_string):
    AnswerEnum = create_dynamic_enum("AnswerEnum", [f"{string}" for string in problem.candidates])

    class DynamicResponse(BaseModel):
        reasoning: str
        final_answer: AnswerEnum

    knowledge = knowledges[0]

    prompt = f"""Select the most appropriate answer. You will be shown a sample question with its correct answer. 
Then, answer a new question of the same type."""

    example_prompt = f"""Example Question:
{str(knowledge)}
Answer: {knowledge.get_ground_truth()}"""
    new_question_prompt = f"""Now try a similar question:
{str(problem)}"""

#     answer_prompt = f"""Example:
# {str(knowledge)}
# Answer: {knowledge.get_ground_truth()}
# {str(problem)}"""
    messages = [
        {"role": "system", "content": prompt},
        {"role": "user", "content": example_prompt},
        {"role": "user", "content": new_question_prompt}
    ]

    prompt = messages




    response = solver_model.interact(prompt, json_format=DynamicResponse, temperature=0)

    return response, response["final_answer"]

