from typing import List

from src.entity.problems.Problem import Problem
import hashlib


class Dataset:
    dataset_name: str
    problems: List[Problem]
    size: int
    def __init__(self, size):
        self.size = size
        self.load_problems()
    '''
    Load Problem from dataset.
    Please refer to the Problem class to see which columns are required.
    '''
    def load_problems(self) -> [Problem]:
        raise NotImplementedError

    @staticmethod
    def generate_hash(input_string):
        """
        Generate a 36-character alphanumeric hash from the input string.

        Args:
            input_string (str): The string to hash.

        Returns:
            str: A 36-character hash.
        """
        # Generate a SHA-256 hash of the input string
        sha256_hash = hashlib.sha256(input_string.encode()).hexdigest()

        # Truncate or extend the hash to 36 characters
        hash_36 = sha256_hash[:36]  # Take the first 36 characters

        return hash_36