# Model is a simple class that handles the API requests to different end services.
import json
from openai import OpenAI
import os

from src.entity.models.Model import Model
from credentials import OPENAI_CREDENTIAL



class GPT5(Model):
    api_key: str
    def __init__(self, ctx_len: int=512):
        print(OPENAI_CREDENTIAL)
        # load from environment variable.
        self.ctx_len = ctx_len
        self.api_key = OPENAI_CREDENTIAL
        # self.ctx_len = ctx_len

    def interact(self, messages: str, **kwargs) -> dict:
        # require a json_format, temperature, e.t.c

        json_format = kwargs.get("json_format")
        temperature = kwargs.get("temperature")
        max_tokens = kwargs.get("max_tokens", 4096)

        messages = [
            {"role": "user", "content": messages}
        ] if isinstance(messages, str) else messages

        if json_format is None:
            raise ValueError("json_format is required")
        if temperature is None:
            raise ValueError("temperature is required")

        # call the API and return the response.
        import openai
        client = OpenAI(api_key=self.api_key)
        prompt_input = {
            "model": "gpt-5",
            "messages": messages,
            "response_format": json_format,
            "n": 1,
            "max_completion_tokens": max_tokens
        }

        

        response = client.beta.chat.completions.parse(
            **prompt_input
        )

        # return a json of the response.
        response = json.loads(response.choices[0].message.content)
        return response