# skeleton
from pydantic import BaseModel


class Schema(BaseModel):
    broad_category: str
    refinement: str
    specific_scope: str
    goal: str

class Response(BaseModel):
    knowledge_schema: Schema
    summary: str


SCHEMA_PROMPT = """
You are a teacher helping students understand a problem. Drawing on schema theory from cognitive psychology, provide a high-level abstraction (schema) of the problem to guide your students. Your schema should include the following components:

Broad Category:
Identify the overarching subject and general category to which the problem belongs.

Refinement:
Describe further details or specific aspects that narrow down the broad category.

Specific Scope:
Define the precise focus or context of the problem within the refined category.

Goal:
Clearly state the objective or intended outcome of solving the problem.

Finally, summarize the schema in a few sentences to help students grasp the key points. The problem you need to abstract is as follows:
"""


SCHEMA_SOLVER_PROMPT = """
Drawing on schema theory from cognitive psychology, think about a high-level abstraction (schema) of the problem to guide your reasoning. Your ultimate goal is to select the most appropriate answer.:

Below is the template for the schema you need to fill out:

Broad Category:
Identify the overarching subject and general category to which the problem belongs.

Refinement:
Describe further details or specific aspects that narrow down the broad category.

Specific Scope:
Define the precise focus or context of the problem within the refined category.

Goal:
Clearly state the objective or intended outcome of solving the problem.

Finally, summarize the schema in a few sentences to help students grasp the key points. The problem you need to abstract is as follows:
"""

SCHEMA_SAMPLE_QUESTION = """
A farmer has 100 acres of land and wants to plant two crops: wheat and corn. Each acre of wheat yields a profit of $200, and each acre of corn yields a profit of $300. However, planting corn requires twice as much water as wheat, and the farmer has only a limited supply of water that can support a maximum of 120 acres of wheat. The farmer wants to maximize their profit while using no more than the available water. How many acres of each crop should the farmer plant?
"""
broad_category = "Mathematics → Optimization → Linear Programming"
refinement = "This problem focuses on maximizing profit within a given set of constraints related to resource availability (land and water)."
specific_scope = "The task involves formulating the problem using variables to represent the number of acres for each crop and solving it by applying linear programming techniques."
goal = "Determine the optimal allocation of resources (acres of land) to maximize the farmer's profit while satisfying the constraints."
sample_schema = Schema(broad_category=broad_category, refinement=refinement, specific_scope=specific_scope,
                       goal=goal)

schema = sample_schema
summary = "This problem involves mathematics, specifically optimization, which focuses on maximizing or minimizing an objective function within given constraints. The scenario describes a farmer's decision to allocate limited resources (land and water) between planting wheat and corn to achieve maximum profit. The task requires formulating the problem as a system of inequalities representing constraints and solving it using linear programming techniques. The goal is to find the optimal number of acres for each crop to maximize profit while satisfying resource limitations."


SCHEMA_SAMPLE_RESPONSE = Response(knowledge_schema=schema, summary=summary)