from src.entity.datasets.GPQA import GPQA
from src.entity.datasets.GPQABiology import GPQABiology
from src.entity.datasets.GPQAPhysics import GPQAPhysics
from src.entity.datasets.Synthetic import Synthetic
from src.entity.datasets.SyntheticBiology import SyntheticBiology
from src.entity.datasets.SyntheticPhysics import SyntheticPhysics
from src.entity.problems.Problem import Problem


def LoadProblemsUseCase(dataset_name: str, size: int) -> Problem:
    """
    Load the knowledge bases for the given dataset names.

    dataset_names: list[str], names of the datasets to load.
    """

    if dataset_name == 'GPQA':
        dataset = GPQA(size=size)
        return dataset.problems
    elif dataset_name == 'Synthetic':
        dataset = Synthetic(size=size)
        return dataset.problems
    elif dataset_name == 'SyntheticPhysics':
        dataset = SyntheticPhysics(size=size)
        return dataset.problems
    elif dataset_name == "GPQAPhysics":
        dataset = GPQAPhysics(size=size)
        return dataset.problems

    elif dataset_name == "SyntheticBiology":
        dataset = SyntheticBiology(size=size)
        return dataset.problems
    elif dataset_name == "GPQABiology":
        dataset = GPQABiology(size=size)
        return dataset.problems
    elif dataset_name == "HLEChemistry":
        from src.entity.datasets.HLEChemistry import HLEChemistry
        dataset = HLEChemistry(size=size)
        return dataset.problems

    elif dataset_name == "HLEMath":
        from src.entity.datasets.HLEMath import HLEMath
        dataset = HLEMath(size=size)
        return dataset.problems
    else:
        raise ValueError(f"Dataset {dataset_name} is not supported.")