from src.entity.KnowledgeBase import KnowledgeBase
from src.entity.problems.Problem import Problem
from src.usecase.retreival.GetReferenceQuestionUseCase import GetReferenceQuestionUseCase
from src.usecase.retreival.GetRelevantKnowledgeByCosSimilarityUseCase import GetRelevantKnowledgeByCosSimilarityUseCase
from src.usecase.retreival.GetRelevantKnowledgeByRerankUseCase import GetRelevantKnowledgeByRerankUseCase


def GetRelevantKnowledgesController(problem: Problem, knowledge_base: KnowledgeBase, top_k: int, approach,
                                    start_similarity, end_similarity,  exclude_self: bool, random_from_k: bool, 
                                    rerank_similarity_start: float = None, rerank_similarity_end: float = None, mapping_path: str = None):
    if approach == "cos_similarity":
        # load start_similarity, end_similarity
        knowledges, similarity = GetRelevantKnowledgeByCosSimilarityUseCase(problem, knowledge_base, top_k,
                                                          start_similarity=start_similarity, end_similarity=end_similarity, exclude_self=exclude_self, random_from_k=random_from_k, exclude_reference = False)
        return knowledges, similarity

    elif approach == "cos_similarity_excluding_reference":
        # load start_similarity, end_similarity
        knowledges, similarity = GetRelevantKnowledgeByCosSimilarityUseCase(problem, knowledge_base, top_k,
                                                          start_similarity=start_similarity, end_similarity=end_similarity, exclude_self=exclude_self, random_from_k=random_from_k, exclude_reference = True)
        return knowledges, similarity

    elif approach == "rag_rerank":
        knowledges, similarity = GetRelevantKnowledgeByRerankUseCase(problem, knowledge_base, rerank_similarity_start, rerank_similarity_end,
                                                                     top_k, random_from_k, exclude_self, mapping_path)
        return knowledges, similarity

    elif approach in ["paraphrase", "new_question", "new_question_exam"]:
        knowledges, similarity = GetReferenceQuestionUseCase(problem, knowledge_base, approach)

        return knowledges, similarity
    elif approach == "self_generate":
        raise Exception("Self Generate Prior Knowledge")
    elif approach == "no_knowledge":
        return None, None
    elif approach == "cot":
        raise Exception("Chain of Thought (CoT) retrieval approach not implemented")
    raise Exception("Retrival Approach not supported")
