from pydantic import BaseModel

from src.entity.problems.Problem import Problem
from config import config

prompt = config["SCHEMA_PROMPT"]
Response = config["SCHEMA_RESPONSE_CLASS"]


def NormalSchemaActivatorUseCase(problem: Problem, knowledges_string, schema_activator_model):
    global prompt
    global Response
    refinement_prompt=f"""
Now, look at a previous question that you have seen, 
along with its schema and summary: 
{knowledges_string}

Now refine your schema you gave for the new question."""


    messages = [
            {"role": "system", "content": prompt},
            {"role": "user", "content": str(problem)},
            {"role": "assistant", "content": problem.mental_representation},
            {"role": "user", "content": refinement_prompt}
        ]

    response = schema_activator_model.interact(messages, json_format=Response, temperature=0)


    formatted_schema = "\n".join(f"##### {key}:\n{value}\n" for key, value in
                                 response["knowledge_schema"].items())
    schema = """#### Schema:
{schema}
#### Summary:
{summary}""".format(schema=formatted_schema, summary=response["summary"])


    return response, schema