import json

from pydantic import BaseModel

from src.entity.problems.Problem import Problem

from pydantic import BaseModel, Field
from enum import Enum
from typing import Type

# Function to dynamically create an Enum
def create_dynamic_enum(name: str, options: list[str]) -> Type[Enum]:
    return Enum(name, {option: option for option in options})

# Example Response model
class Response(BaseModel):
    reasoning: str
    final_answer: Enum


def BaselineSolverUseCase(problem: Problem, solver_model, knowledges):
    AnswerEnum = create_dynamic_enum("AnswerEnum", [f"{string}" for string in problem.candidates])

    class DynamicResponse(BaseModel):
        reasoning: str
        final_answer: AnswerEnum

    prompt = f"""Select the most appropriate answer."""
    answer_prompt = f"""Question: {str(problem)}"""
    messages = [{"role": "system", "content": prompt}, {"role": "user", "content": answer_prompt}, ]
    response = solver_model.interact(messages, json_format=DynamicResponse, temperature=0)

    if response is None:
        return None, None

    return response, response["final_answer"]
