import json
from src.entity.problems.Problem import Problem
from pydantic import BaseModel, Field
from enum import Enum
from typing import Type
from config import config
prompt = config["SCHEMA_PROMPT"]
Response = config["SCHEMA_RESPONSE_CLASS"]
SCHEMA_SOLVER_PROMPT = config["SCHEMA_SOLVER_PROMPT"]

def create_dynamic_enum(name: str, options: list[str]) -> Type[Enum]:
    return Enum(name, {option: option for option in options})

def SchemaSolverUseCase(problem: Problem, schema: str, solver_model, knowledges, knowledges_string):
    global prompt
    AnswerEnum = create_dynamic_enum("AnswerEnum", [f"{string}" for string in problem.candidates])

    class DynamicResponse(BaseModel):
        reasoning: str
        final_answer: AnswerEnum

    prompt = f"""Now that you've defined your schema for the current question, select the most appropriate answer."""

    answer_prompt = f"""{str(problem)}
{schema}"""


    messages = [{"role": "system", "content": prompt}, {"role": "user", "content": answer_prompt}, ]

    prompt = messages

    response = solver_model.interact(messages, json_format=DynamicResponse, temperature=0)

    return response, response["final_answer"]
