from src.usecase.solver.BaselineSolverUseCase import BaselineSolverUseCase
from src.usecase.solver.ExampleSchemaSolver import ExampleSchemaSolverUseCase
from src.usecase.solver.ExampleSolverUseCase import ExampleSolverUseCase
from src.usecase.solver.SchemaSolverUseCase import SchemaSolverUseCase
from src.usecase.solver.ExampleSchemaNoActivationSolver import ExampleSchemaNoActivation


def SolveController(problem_string: str, schema: str, solver_type, solver_model, knowledges, formatted_knowledges):
    print(solver_type)
    if solver_type == "SchemaSolver":
        response, final_answer = SchemaSolverUseCase(problem_string, schema, solver_model, knowledges, formatted_knowledges)
    elif solver_type == "BaselineSolver":
        response, final_answer = BaselineSolverUseCase(problem_string, solver_model, knowledges)
    elif solver_type == "ExampleSolver":
        response, final_answer = ExampleSolverUseCase(problem_string, schema, solver_model, knowledges, formatted_knowledges)

    elif solver_type == "ExampleSchemaSolver":
        response, final_answer = ExampleSchemaSolverUseCase(problem_string, schema, solver_model, knowledges, formatted_knowledges)

    elif solver_type == "ExampleSchemaNoActivationSolver":
        response, final_answer = ExampleSchemaNoActivation(problem_string, schema, solver_model, knowledges, formatted_knowledges)

    return response, final_answer
